/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.base;

import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class VWUDDIPublishStatus {
    private final ImageIcon ICON_SUCCEEDED = VWImageLoader.createImageIcon("check_16.gif");
    private final ImageIcon ICON_ERROR = VWImageLoader.createImageIcon("error_16.gif");
    private final ImageIcon ICON_BLANK = VWImageLoader.createImageIcon("blank.gif");
    private String m_id = null;
    private String m_msg = null;
    private int m_status = 0;

    public VWUDDIPublishStatus(String id, int status, String msg) {
        this.m_id = id;
        this.m_status = status;
        this.m_msg = msg;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public String getMessage() {
        return this.m_msg;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setMessage(String msg) {
        this.m_msg = msg;
    }

    public void setStatus(int bStatus) {
        this.m_status = bStatus;
    }

    public JLabel toWSRRJLabel(int processOption) {
        JLabel label = new JLabel();
        switch (this.m_status) {
            case 1: {
                if (processOption == 2) {
                    label.setText(VWResource.s_businessArgDeleted.toString(this.m_id));
                } else {
                    label.setText(VWResource.s_publishSucceeded.toString(this.m_id));
                }
                label.setIcon(this.ICON_SUCCEEDED);
                break;
            }
            case 2: {
                if (this.m_id == null || this.m_id.length() <= 0) {
                    label.setText(VWResource.s_failedToPublishWorkflow1.toString(this.m_msg));
                } else {
                    label.setText(VWResource.s_failedToPublishWorkflow2.toString(this.m_id, this.m_msg));
                }
                label.setIcon(this.ICON_ERROR);
                break;
            }
            case 3: {
                label.setText(VWResource.s_processInterruptedArg.toString(this.m_msg));
                break;
            }
            case 4: {
                label.setText(VWResource.s_processCompletedArg.toString(this.m_msg));
                break;
            }
            case 6: {
                label.setText(VWResource.s_publishCanceled);
                break;
            }
            case 5: {
                label.setText(VWResource.s_publishFailedArg.toString(this.m_msg));
                break;
            }
            default: {
                label.setText("\"" + this.m_id + "\": " + this.m_msg);
                label.setIcon(this.ICON_BLANK);
            }
        }
        return label;
    }
}

